//
//  CRNSBoxBase.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 12/16/11.
//  Copyright 2011 Neatberry. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Custom box
//////////////////////////////////////////////////////////////////////
@interface CRNSBoxBase : NSBox
{
    float					borderWidth;
    NSColor*				borderColor;
    NSColor*				titleColor;
    NSColor*				backgroundColor;
    NSMutableDictionary*	titleAttrs;
    BOOL					selected;
	
@protected
	NSBezierPath*			controlPath;
}

- (void)setDefaults;
- (NSRect)boxRect;

- (BOOL)selected;
- (void)setSelected:(BOOL)newSelected;
- (NSColor *)borderColor;
- (void)setBorderColor:(NSColor *)newBorderColor;
- (NSColor *)titleColor;
- (void)setTitleColor:(NSColor *)newTitleColor;
- (NSColor *)backgroundColor;
- (void)setBackgroundColor:(NSColor *)newBackgroundColor;

@end